﻿namespace Code6587EN.Ch01.UploadFontScheme
{
    using Microsoft.SharePoint;
    using System;
    using System.IO;

    /// <summary>
    /// Console Application to upload a Font Scheme
    /// </summary>
    class Program
    {
        static void Main(string[] args)
        {
            // Open the SharePoint Site Collection containing the SharePoint Site in a Using statement
            using (var site = new SPSite("http://sharepoint/site"))
            {
                // Open the SharePoint Site in a Using statement
                using (var web = site.OpenWeb())
                {
                    // Set the path to the file
                    var filePath = "C:\\myfonts.spfont";

                    // Get the _catalogs/theme/15 folder
                    var themeFolder = web.Folders["_catalogs"].SubFolders["theme"].SubFolders["15"];

                    // Get the file name from the path
                    var fileName = Path.GetFileName(filePath);

                    // Get the file contents
                    var fileStream = File.OpenRead(filePath);

                    // Add the file to the folder
                    themeFolder.Files.Add(fileName, fileStream, true);

                    // Update the folder
                    themeFolder.Update();
                }
            }

            // Wait for a key to be pressed before closing the application
            Console.WriteLine("Press Any Key to Continue...");
            Console.Read();
        }
    }
}
